/*----------------------------------------------------------------------------------------*
 * SurfacePlotter.java                                                                    *
 *                                                                                        *
 * Surface Plotter   version 1.10    14 Oct 1996                                          *
 *                   version 1.20     8 Nov 1996                                          *
 *                   version 1.30b1  17 May 1997                                          *
 *                   version 1.30b2  18 Oct 2001                                          *
 * Copyright (c) Yanto Suryono <yanto@fedu.uec.ac.jp>                                     *
 *                                                                                        *
 *                                                                                        *
 * MathOptAnimator   version 1.00     10 Feb 2002                                         *
 * Copyright (c) 2003 Ramazan Buzdemir <buzdemir@zpr.uni-koeln.de>                        *
 *                                                                                        *
 *                                                                                        *
 * This program is free software; you can redistribute it and/or modify it                *
 * under the terms of the GNU General Public License as published by the                  *
 * Free Software Foundation; either version 2 of the License, or (at your option)         *
 * any later version.                                                                     *
 *                                                                                        *
 * This program is distributed in the hope that it will be useful, but                    *
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or          *
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for               *
 * more details.                                                                          *
 *                                                                                        *
 * You should have received a copy of the GNU General Public License along                *
 * with this program; if not, write to the Free Software Foundation, Inc.,                *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA                                  *
 *                                                                                        *
 *----------------------------------------------------------------------------------------*/

import java.applet.*;
import java.awt.*;

/**
 * The class <code>SurfacePlotter</code> is the main class of Surface Plotter.
 * It extends <code>java.awt.applet.Applet</code> but also has the <code>main</code>
 * method, so the Surface Plotter can be run as an applet or an application.
 *
 * @author  Yanto Suryono
 */
 
public class SurfacePlotter extends Applet {	


SecurityManager security = System.getSecurityManager();

  public  static final String  APP_NAME    = "MathOptAnimator";
  public  static final String  APP_VERSION = "Version 1.00";
  public  static final String  APP_VERSIGN = "1.00";
  public  static final String  APP_DATE    = "10 Feb 2003";

  private Button       button;
  private SurfaceFrame frame;
    
  /**
   * Initializes Surface Plotter applet.
   */
   
  public void init() {
    String BUTTON_TEXT = getParameter("button_text");
    if (BUTTON_TEXT == null) BUTTON_TEXT = "MathOptAnimator starten";
    
    setFont(new Font("Dialog", Font.BOLD, 12));
    setLayout(new BorderLayout());
    add("Center", button = new Button(BUTTON_TEXT));
    button.setBackground(new Color(153,204,255));
    //button.setForeground(new Color(0,51,153));
  }
  
  /**
   * Gets Surface Plotter applet information.
   */
   
  public String getAppletInfo() {
    return APP_NAME + " " + APP_VERSION + "\n" +
           "Copyright (c) 2002 Ramazan Buzdemir\n" +
           "Compiled: " + APP_DATE + "\n\n";
  }

  /**
   * Disposes Surface Plotter frame.
   */
   
  public void disposeWindow() { 	
    frame.dispose();
    frame = null;
  }

  /**
   * Handles user actions.  
   *
   * @param e the event
   */

  public boolean action(Event e, Object arg) {
    if (e.target == button)
      if (frame == null) 
        frame = new SurfaceFrame(this);
      else
        frame.toFront();
    else 
      return super.action(e,arg);
    return true;
  }

  /**
   * The main method. Execution starts here when Surface Plotter is
   * run as an application.
   */
   
  public static void main(String args[]) {	
    new SurfaceFrame(null);
  }
}