/*----------------------------------------------------------------------------------------*
 * SettingPanel.java                                                                      *
 *                                                                                        *
 * Surface Plotter   version 1.10    14 Oct 1996                                          *
 *                   version 1.20     8 Nov 1996                                          *
 *                   version 1.30b1  17 May 1997                                          *
 *                   version 1.30b2  18 Oct 2001                                          *
 *                                                                                        *
 * Copyright (c) Yanto Suryono <yanto@fedu.uec.ac.jp>                                     *
 *                                                                                        *
 *                                                                                        *
 * MathOptAnimator   version 1.00     10 Feb 2002                                         *
 * Copyright (c) 2003 Ramazan Buzdemir <buzdemir@zpr.uni-koeln.de>                        *
 *                                                                                        *
 *                                                                                        *
 * This program is free software; you can redistribute it and/or modify it                *
 * under the terms of the GNU General Public License as published by the                  *
 * Free Software Foundation; either version 2 of the License, or (at your option)         *
 * any later version.                                                                     *
 *                                                                                        *
 * This program is distributed in the hope that it will be useful, but                    *
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or          *
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for               *
 * more details.                                                                          *
 *                                                                                        *
 * You should have received a copy of the GNU General Public License along                *
 * with this program; if not, write to the Free Software Foundation, Inc.,                *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA                                  *
 *                                                                                        *
 *----------------------------------------------------------------------------------------*/

import java.awt.*;

/**
 * The class <code>SettingPanel</code> produces panel that contains several
 * control objects that modify Surface Plotter's settings and send commands to
 * Surface Plotter.  
 *
 * @author  Yanto Suryono
 */

public final class SettingPanel extends Panel {
  private SurfaceFrame frame;	

  private String INIT_DIVISIONS = "20";
  private String INIT_XMIN = "-4.0";
  private String INIT_XMAX = "1.0";
  private String INIT_YMIN = "-2.0";
  private String INIT_YMAX = "3.0";
  private String INIT_ZMIN = "-3.0";
  private String INIT_ZMAX = "1.0"; 
	
  private Button calc, scale;
  private Checkbox delay_regen;	
  private InputField calcdivisions;
  private InputField xmin,xmax,ymin,ymax,zmin,zmax;
         
  private final int MIN_DIVISIONS = 10;
  private final int MAX_DIVISIONS = 150;
  private final int DEF_DIVISIONS = 20;

  private final int SIZE1 = 3;
  private final int SIZE2 = 13;
     
  /**
   * The constructor of <code>SettingPanel</code>.
   *
   */

  SettingPanel(SurfaceFrame frame) {
    this.frame = frame;
    
    Panel panel_0, panel_1, panel_2, panel_3, panel_4;
    StaticLabel message;
    InputField[] inputfield = new InputField[6];
    
    setBackground(Color.lightGray);
    setLayout(new BorderLayout(0,10));

//-------------------------------------------------------------------------------------------------
    panel_0 = new Panel();
    panel_0.setLayout(new BorderLayout(0,10)); 

    panel_1 = new Panel();
    panel_1.setLayout(new GridLayout(3,1,0,2));

    panel_2 = new Panel();
    panel_2.setLayout(new BorderLayout());     
    panel_2.add("Center", calc = new Button("Funktion zeichnen"));
    panel_1.add(panel_2); 
    
    panel_2 = new Panel();
    panel_2.setLayout(new BorderLayout());     
    panel_2.add("West", delay_regen = new Checkbox("Verzgerter Bildaufbau"));
    panel_1.add(panel_2);
        
    panel_2 = new Panel();
    panel_2.setLayout(new BorderLayout());
    panel_2.add("East", inputfield[0] = 
                new InputField(SIZE1,(float)MIN_DIVISIONS,(float)MAX_DIVISIONS,1.0f,true));
    panel_2.add("Center", message = new StaticLabel("Anz. Gitterpunkte =",true));
    panel_1.add(panel_2);
    
    panel_0.add("North", panel_1);
    
    calcdivisions = inputfield[0];
    
    if (frame.applet != null) {    	
      String parameter;
      parameter = frame.applet.getParameter("init_divisions");      
      if (parameter != null) INIT_DIVISIONS = parameter;
    };
    calcdivisions.setText(INIT_DIVISIONS);
//------------------------------------------------------------------------------------------------- 
 
//-------------------------------------------------------------------------------------------------    
    panel_1 = new Panel();
    panel_1.setLayout(new BorderLayout());

    panel_2 = new Panel();
    panel_2.setLayout(new GridLayout(3,1,0,10)); 
      
    panel_3 = new Panel();
    panel_3.setLayout(new GridLayout(2,1));
    panel_4 = new Panel();
    panel_4.setLayout(new BorderLayout());    
    panel_4.add("East", inputfield[0] = 
                new InputField(SIZE2,-1.0f/0.0f,1.0f/0.0f,1.0f,false));
    panel_4.add("Center",message = new StaticLabel("x-min",true));
    panel_3.add(panel_4);    
    panel_4 = new Panel();
    panel_4.setLayout(new BorderLayout());    
    panel_4.add("East", inputfield[1] = 
                new InputField(SIZE2,-1.0f/0.0f,1.0f/0.0f,1.0f,false));
    panel_4.add("Center",message = new StaticLabel("x-max",true));
    panel_3.add(panel_4);
    panel_2.add(panel_3);
    
    panel_3 = new Panel();
    panel_3.setLayout(new GridLayout(2,1));
    panel_4 = new Panel();
    panel_4.setLayout(new BorderLayout());    
    panel_4.add("East", inputfield[2] = 
                new InputField(SIZE2,-1.0f/0.0f,1.0f/0.0f,1.0f,false));
    panel_4.add("Center",message = new StaticLabel("y-min",true));
    panel_3.add(panel_4);    
    panel_4 = new Panel();
    panel_4.setLayout(new BorderLayout());    
    panel_4.add("East", inputfield[3] = 
                new InputField(SIZE2,-1.0f/0.0f,1.0f/0.0f,1.0f,false));
    panel_4.add("Center",message = new StaticLabel("y-max",true));
    panel_3.add(panel_4);
    panel_2.add(panel_3);    
    
    panel_3 = new Panel();
    panel_3.setLayout(new GridLayout(2,1));
    panel_4 = new Panel();
    panel_4.setLayout(new BorderLayout());    
    panel_4.add("East", inputfield[4] = 
                new InputField(SIZE2,-1.0f/0.0f,1.0f/0.0f,1.0f,false));
    panel_4.add("Center",message = new StaticLabel("z-min",true));
    panel_3.add(panel_4);    
    panel_4 = new Panel();
    panel_4.setLayout(new BorderLayout());    
    panel_4.add("East", inputfield[5] = 
                new InputField(SIZE2,-1.0f/0.0f,1.0f/0.0f,1.0f,false));
    panel_4.add("Center",message = new StaticLabel("z-max",true));
    panel_3.add(panel_4);
    panel_2.add(panel_3);

    panel_1.add("North", panel_2);
    
    panel_0.add("Center",panel_1);
    
    add("North",panel_0);
    
    xmin = inputfield[0];
    xmax = inputfield[1];
    ymin = inputfield[2];
    ymax = inputfield[3];
    zmin = inputfield[4];
    zmax = inputfield[5];

    if (frame.applet != null) {    	
      String parameter;
      parameter = frame.applet.getParameter("init_xmin");      
      if (parameter != null) INIT_XMIN = parameter;
      parameter = frame.applet.getParameter("init_xmax");      
      if (parameter != null) INIT_XMAX = parameter;
      parameter = frame.applet.getParameter("init_ymin");      
      if (parameter != null) INIT_YMIN = parameter;
      parameter = frame.applet.getParameter("init_ymax");      
      if (parameter != null) INIT_YMAX = parameter;
      parameter = frame.applet.getParameter("init_zmin");      
      if (parameter != null) INIT_ZMIN = parameter;
      parameter = frame.applet.getParameter("init_zmax");      
      if (parameter != null) INIT_ZMAX = parameter;
    };
    setRanges(INIT_XMIN, INIT_XMAX, INIT_YMIN, INIT_YMAX, INIT_ZMIN, INIT_ZMAX);
//------------------------------------------------------------------------------------------------- 
 
    Label text;
    
    panel_0 = new Panel();
    panel_0.setLayout(new BorderLayout(0,10));
     
    panel_0.add("North", scale = new Button("Skalierung zurcksetzen"));
    
    panel_1 = new Panel();
    panel_1.setLayout(new BorderLayout());
    
    panel_2 = new Panel();
    panel_2.setLayout(new GridLayout(3,1,0,-7));
    
    text = new Label("Maustaste :",Label.RIGHT);
    text.setFont(new Font("Helvetica", Font.BOLD, 11));
    panel_2.add(text);  
    
    text = new Label("+ <shift> :",Label.RIGHT);
    text.setFont(new Font("Helvetica", Font.BOLD, 11));
    panel_2.add(text);
    
    text = new Label("+ <strg> :",Label.RIGHT);
    text.setFont(new Font("Helvetica", Font.BOLD, 11));
    panel_2.add(text);
    
    panel_1.add("West",panel_2);
    
    panel_2 = new Panel();
    panel_2.setLayout(new GridLayout(3,1,0,-7));
    
    text = new Label("drehen",Label.LEFT);
    panel_2.add(text);
    
    text = new Label("skalieren",Label.LEFT);
    panel_2.add(text);
    
    text = new Label("verschieben",Label.LEFT);
    panel_2.add(text); 
    
    panel_1.add("Center",panel_2);
        
    panel_0.add("Center",new SurfaceBorder(panel_1,false));
    
    add("South", panel_0);

  }

  /**
   * Sets variable ranges. Affects displayed values.
   *
   * @param xi the minimum x
   * @param yi the minimum y
   * @param zi the minimum z
   * @param xa the maximum x
   * @param ya the maximum y
   * @param za the maximum z
   */
   
  public void setRanges(String xi, String xa, 
                        String yi, String ya,
                        String zi, String za) {
    xmin.setText(xi);
    xmax.setText(xa);
    ymin.setText(yi);
    ymax.setText(ya);    
    zmin.setText(zi);
    zmax.setText(za);
  }

  /**
   * Determines whether the delay regeneration checkbox is checked.
   *
   * @return <code>true</code> if the checkbox is checked, 
   *         <code>false</code> otherwise
   */

  public boolean isExpectDelay() {
    return delay_regen.getState();
  }
  
  /**
   * Gets the current minimum x value.
   *
   * @return string representation of the minimum x
   */
   
  public String getXMin() {
    return xmin.getText();
  }

  /**
   * Gets the current minimum y value.
   *
   * @return string representation of the minimum y
   */

  public String getYMin() {
    return ymin.getText();
  }
  
  /**
   * Gets the current minimum z value.
   *
   * @return string representation of the minimum z
   */

  public String getZMin() {
    return zmin.getText();
  }
  
  /**
   * Gets the current maximum x value.
   *
   * @return string representation of the maximum x
   */

  public String getXMax() {
    return xmax.getText();
  }

  /**
   * Gets the current maximum y value.
   *
   * @return string representation of the maximum y
   */

  public String getYMax() {
    return ymax.getText();
  }
  
  /**
   * Gets the current maximum z value.
   *
   * @return string representation of the maximum z
   */

  public String getZMax() {
    return zmax.getText();
  }

  public void setEnabled(boolean b) {
    calc.setEnabled(b);
    scale.setEnabled(b);
    delay_regen.setEnabled(b);
    calcdivisions.setEnabled(b);
    xmin.setEnabled(b);
    xmax.setEnabled(b);
    ymin.setEnabled(b);
    ymax.setEnabled(b);
    zmin.setEnabled(b);
    zmax.setEnabled(b);
    if (b)
      calc.setLabel("Funktion zeichnen");
    else
      calc.setLabel("Zeichne Funktion ...");
  }

  /**
   * Gets the number of divisions to be calculated.
   * Automatically fixes invalid values.
   *
   * @return valid number of divisions to be calculated
   */ 
   
  public int getCalcDivisions() {
    int value;

    try {
      value = Integer.parseInt(calcdivisions.getText());
    }
    catch(NumberFormatException e) {
      value = -1;
    }
    if ((value < MIN_DIVISIONS) || (value > MAX_DIVISIONS)) {
      value = DEF_DIVISIONS; 
      calcdivisions.setText("" + DEF_DIVISIONS);
    }
    return value; 
  }

  /**
   * Gets the number of divisions to be displayed.
   * Automatically fixes invalid values.
   *
   * @return valid number of divisions to be displayed
   */ 
  
  public int getDispDivisions() {
    return getCalcDivisions();
  }

  /**
   * Sets the number of divisions to be calculated.
   *
   * @param divisions number of divisions to be calculated
   */ 

  public void setCalcDivisions(int divisions) {
    calcdivisions.setText(Integer.toString(divisions));
  } 

  /**
   * Handles user actions.
   *
   * @param e the event
   * @param arg additional information from event manager 
   */

  public boolean action(Event e, Object arg) {
    if (e.target instanceof Button) {
    	
      if (arg.equals("Funktion zeichnen")) {
        frame.plot(true,true);
        return true;
      }
       
      if (arg.equals("Skalierung zurcksetzen")) {
        if (getToolkit().getScreenSize().width < 1024)
          frame.canvas.projector.set2DScaling(10);
        else
          frame.canvas.projector.set2DScaling(14);
        frame.plot(true,true); 
        return true;
      }
      
    }
    else
    if (e.target instanceof Checkbox) {
      if (e.target != delay_regen) return false; // propagates to parent
      return true;
    }
    
    return super.action(e,arg);
  }
  
}
