/*----------------------------------------------------------------------------------------*
 * FunctionPanel.java                                                                     *
 *                                                                                        *
 * Surface Plotter   version 1.10    14 Oct 1996                                          *
 *                   version 1.20     8 Nov 1996                                          *
 *                   version 1.30b1  17 May 1997                                          *
 *                   version 1.30b2  18 Oct 2001                                          *
 *                                                                                        *
 * Copyright (c) Yanto Suryono <yanto@fedu.uec.ac.jp>                                     *
 *                                                                                        *
 *                                                                                        *
 * MathOptAnimator   version 1.00     10 Feb 2002                                         *
 * Copyright (c) 2003 Ramazan Buzdemir <buzdemir@zpr.uni-koeln.de>                        *
 *                                                                                        *
 *                                                                                        *
 * This program is free software; you can redistribute it and/or modify it                *
 * under the terms of the GNU General Public License as published by the                  *
 * Free Software Foundation; either version 2 of the License, or (at your option)         *
 * any later version.                                                                     *
 *                                                                                        *
 * This program is distributed in the hope that it will be useful, but                    *
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or          *
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for               *
 * more details.                                                                          *
 *                                                                                        *
 * You should have received a copy of the GNU General Public License along                *
 * with this program; if not, write to the Free Software Foundation, Inc.,                *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA                                  *
 *                                                                                        *
 *----------------------------------------------------------------------------------------*/

import java.awt.*;

/**
 * The class <code>FunctionPanel</code> contains function input field, 
 * Surface Plotter logo, status line and several checkboxes to control 
 * Surface Plotter's behaviour. 
 *
 * @author  Yanto Suryono
 */
 
public final class FunctionPanel extends Panel {
  private SurfaceFrame frame;
  
  //private String INIT_FUNCTION = "x^2+y^2+x*y+2*x-1";
  private String INIT_FUNCTION = "(x^2+y^2+x*y+2*x-1)*sin(y)";
  
  private TextField function;  
  private StaticLabel message;
  
  /**
   * The constructor of <code>FunctionPanel</code>
   */

  FunctionPanel(SurfaceFrame frame) {
    this.frame = frame;
  	
    setBackground(Color.lightGray);
    setLayout(new BorderLayout());

    Panel panel1;
    
    panel1 = new Panel();
    panel1.setLayout(new GridLayout(2,1));
    panel1.add(new StaticLabel("f(x,y) =",true));
    panel1.add(new StaticLabel("Status :",true));
    add("West", panel1);

    panel1 = new Panel();
    panel1.setLayout(new GridLayout(2,1));
    panel1.add(function = new TextField());  
    panel1.add(message = new StaticLabel("",true));    
    add("Center", panel1);
    
    if (frame.applet != null) {    	
      String parameter;
      parameter = frame.applet.getParameter("init_function");
      if (parameter != null) INIT_FUNCTION = parameter;
    };
    setFunctionDefinition(INIT_FUNCTION); 
  }
  
  public void setEnabled(boolean b) {
    function.setEnabled(b);
  }  
  
  /**
   * Sets the text of status line
   *
   * @param text new text to be displayed
   */
       
  public void setMessage(String text) {
    message.setForeground(Color.black);	
    message.setText(text);
  }
  
  public void setErrorMessage(String text) {
    message.setForeground(Color.red);
    message.setText(text);
  }
  
  /**
   * Moves the keyboard cursor to the error position in 
   * function definition.
   *
   * @param position the error position (zero based)
   */

  public void setErrorPosition(int position) {
    position--;
    function.select(position,position); 
    function.requestFocus();
  }

  /**
   * Gets the first function defintion.
   *
   * @return the function definition
   */
   
  public String getFunctionDefinition() {
    return function.getText();
  }

  /**
   * Sets the first function defintion.
   *
   * @param definition of first function
   */

  public void setFunctionDefinition(String definition) {
    function.setText(definition);
  }
}


