/*----------------------------------------------------------------------------------------*
 * AlgorithmPanel.java                                                                    *
 *                                                                                        *
 *                                                                                        *
 * MathOptAnimator   version 1.00     10 Feb 2002                                         *
 * Copyright (c) 2003 Ramazan Buzdemir <buzdemir@zpr.uni-koeln.de>                        *
 *                                                                                        *
 *                                                                                        *
 * This program is free software; you can redistribute it and/or modify it                *
 * under the terms of the GNU General Public License as published by the                  *
 * Free Software Foundation; either version 2 of the License, or (at your option)         *
 * any later version.                                                                     *
 *                                                                                        *
 * This program is distributed in the hope that it will be useful, but                    *
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or          *
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for               *
 * more details.                                                                          *
 *                                                                                        *
 * You should have received a copy of the GNU General Public License along                *
 * with this program; if not, write to the Free Software Foundation, Inc.,                *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA                                  *
 *                                                                                        *
 *----------------------------------------------------------------------------------------*/

import java.awt.*;

/**
 * The class <code>SettingPanel</code> produces panel that contains several
 * control objects that modify Surface Plotter's settings and send commands to
 * Surface Plotter.  
 *
 * @author  Yanto Suryono
 */

public final class AlgorithmPanel extends Panel {
  private SurfaceFrame frame;
  public Algorithm algorithm;

  private String INIT_X0 = "1.0";
  private String INIT_Y0 = "1.0";    
  //private String INIT_FUNCTYPE = "quadratisch";
  private String INIT_FUNCTYPE = "differenzierbar";
  private String INIT_ALGTYPE  = "Hestenes-Stiefel";
  
  private final int min_exp = -8;
  private final int max_exp = -3;
  private final int def_exp = -4;
  private final int min_i = 10;
  private final int max_i = 500;
  private final int def_i = 100;
  
  private Button start, stop;
  private Choice functiontype, algorithmtype;
  private TextField x0, y0;  
  private StaticLabel atLabel, bcLabel, miLabel;
  private InputField breakcondition, maxiteration;
  public TextArea output;
 
  AlgorithmPanel(SurfaceFrame frame) {
    this.frame = frame;  	
    algorithm = new Algorithm(frame);
      	
    Panel panel1, panel2, panel3, panel4, panel5;
  	
    setBackground(Color.lightGray);
    setLayout(new BorderLayout(10,0));
    
    panel1 = new Panel();
    panel1.setLayout(new BorderLayout(0,5));
    
    panel2 = new Panel();
    panel2.setLayout(new BorderLayout());
    panel2.add("Center", start = new Button("Algorithmus starten"));
    panel2.add("East", stop = new Button("   Abbruch   ")); 
    panel1.add("North", panel2);
    stop.setEnabled(false);
    
    panel2 = new Panel();
    panel2.setLayout(new GridLayout(5,1,0,1));
    panel3 = new Panel();
    panel3.setLayout(new BorderLayout());
    panel3.add("West", new StaticLabel("Startvektor (x0,y0) = (",true));
    panel4 = new Panel();
    panel4.setLayout(new BorderLayout());
    panel5 = new Panel();
    panel5.setLayout(new BorderLayout());
    panel5.add("West", x0 = new TextField());
    panel5.add("Center", new StaticLabel(",",true));    
    panel4.add("West",panel5);
    panel5 = new Panel();
    panel5.setLayout(new BorderLayout());
    panel5.add("West", y0 = new TextField());    
    panel5.add("Center", new StaticLabel(")",true));
    panel4.add("Center",panel5);          
    panel3.add("Center", panel4);
    panel2.add(panel3);

    panel3 = new Panel();
    panel3.setLayout(new BorderLayout());
    panel3.add("West", new StaticLabel("Funktionsform :",true));
    functiontype = new Choice();
    functiontype.addItem("quadratisch");
    functiontype.addItem("differenzierbar");
    panel3.add("Center", functiontype);   
    panel2.add(panel3);

    panel3 = new Panel();
    panel3.setLayout(new BorderLayout());
    panel3.add("West", atLabel = new StaticLabel("alphak berechnen nach",true));
    algorithmtype = new Choice();
    algorithmtype.addItem("Hestenes-Stiefel");
    algorithmtype.addItem("Fletcher-Reeves");
    algorithmtype.addItem("Polak-Ribiere");
    panel3.add("Center", algorithmtype);
    panel2.add(panel3);
        
    panel3 = new Panel();
    panel3.setLayout(new BorderLayout());
    panel3.add("West", bcLabel = new StaticLabel("Abbruch, falls ||grad(xk,yk)|| <= 10^",true));
    panel3.add("Center", breakcondition = new InputField(3,min_exp,max_exp,1,true));
    breakcondition.setText(String.valueOf(def_exp));
    panel2.add(panel3);
    
    panel3 = new Panel();
    panel3.setLayout(new BorderLayout());
    panel3.add("West", miLabel = new StaticLabel("Abbruch, falls k >",true));
    panel3.add("Center", maxiteration = new InputField(3,min_i,max_i,1,true));
    maxiteration.setText(String.valueOf(def_i));
    panel2.add(panel3);  

    panel1.add("Center", panel2);
    
    add("West", panel1);
    
        
    output = new TextArea("",1,1);
    output.setBackground(Color.lightGray);
    output.setEditable(false);
    output.append
      ("==========================================================================");
    output.append
      ("\n  " + "Ausgabe:" + "\n");
    output.append
      ("==========================================================================");
    
    add("Center", output);

    if (frame.applet != null) {
      String parameter;
      parameter = frame.applet.getParameter("init_x0");
      if (parameter != null) INIT_X0 = parameter;
      parameter = frame.applet.getParameter("init_y0");      
      if (parameter != null) INIT_Y0 = parameter;   
      parameter = frame.applet.getParameter("init_functype");
      if (parameter != null) INIT_FUNCTYPE = parameter;
      parameter = frame.applet.getParameter("init_algtype");
      if (parameter != null) INIT_ALGTYPE = parameter;
    }
    x0.setText(INIT_X0);
    y0.setText(INIT_Y0);
    functiontype.select(INIT_FUNCTYPE);
    algorithmtype.select(INIT_ALGTYPE);
    
//if (INIT_FUNCTYPE == "differenzierbar") {
// start.setLabel("Under Construction");
// start.setEnabled(false);
// stop.setEnabled(false);
//}
  }  
  
  public void setDiffVisible(boolean b) {
    atLabel.setVisible(b);
    algorithmtype.setVisible(b);
    bcLabel.setVisible(b);
    breakcondition.setVisible(b);
    miLabel.setVisible(b);
    maxiteration.setVisible(b);
  }
  
  public void setEnabled(boolean b) {
    frame.function_panel.setEnabled(b);
    x0.setEnabled(b);
    y0.setEnabled(b);
    functiontype.setEnabled(b);
    algorithmtype.setEnabled(b);
    breakcondition.setEnabled(b);
    maxiteration.setEnabled(b);
    stop.setEnabled(!b);
    if (b)
      start.setLabel("Algorithmus starten");
    else
      start.setLabel("Nchster Iterationsschritt");
  }
  
  public String getFunctionType() {
    return functiontype.getSelectedItem();
  }

  public String getAlgorithmType() {
    return algorithmtype.getSelectedItem();
  }

  public String getX0() {
    return x0.getText();
  }

  public String getY0() {
    return y0.getText();
  }

  public String getBreakCondition() {
    return breakcondition.getText();
  }
  
  public String getMaxIteration() {
    return maxiteration.getText();
  }  

  public boolean validValues() {
    float floatValue;
    int   intValue;    
    try {
      floatValue = Float.valueOf(getX0()).floatValue();
      floatValue = Float.valueOf(getY0()).floatValue();
    }
    catch(NumberFormatException e) {
      frame.function_panel.setErrorMessage("Fehler: x0 ist keine Zahl");
      return false;
    }        
    try {
      intValue = Integer.parseInt(getBreakCondition());
      if ((intValue < min_exp) || (intValue > max_exp)) {
        frame.function_panel.setErrorMessage
             ("Fehler: exponent(||dk||) muss zwischen " +
              min_exp + " und " + max_exp + " liegen");
        return false;
      }       
    }
    catch(NumberFormatException e) {
      frame.function_panel.setErrorMessage("Fehler: exponent(||dk||) ist keine Zahl");
      return false;
    }    
    try {
      intValue = Integer.parseInt(getMaxIteration());
      if ((intValue < min_i) || (intValue > max_i)) {
        frame.function_panel.setErrorMessage
             ("Fehler: max_k muss zwischen " +
              min_i + " und " + max_i + " liegen");
        return false;
      }       
    }
    catch(NumberFormatException e) {
      frame.function_panel.setErrorMessage("Fehler: max_k ist keine Zahl");
      return false;
    }    
    return true;
  }

  public boolean action(Event e, Object arg) {
    String cChoice;
    if (e.target instanceof Choice) {
      cChoice = ((Choice)e.target).getSelectedItem();
      
      if (cChoice == "quadratisch") {	
        stop.setEnabled(false);
      	setDiffVisible(false);
      	return true;
      }
      
      if (cChoice == "differenzierbar") {
        stop.setEnabled(false);
        setDiffVisible(true);
        return true;
      }
      
    }
    else 
    if (e.target instanceof Button) {
      
      if (arg.equals("Algorithmus starten")) {
	//frame.setting_panel.setRanges("-3.0","3.0","-3.0","3.0","-2.0","2.0");
        if (validValues() && frame.plot(true,false)) {
          start.setEnabled(false);	
          algorithm.start();
          start.setEnabled(true);
        }
        return true;
      }
      
      if (arg.equals("   Abbruch   ")) {
        output.append("\n  " + "Abbruch des Algorithmus durch den Benutzer !");
        algorithm.stop();
        return true;
      }
      
      if (arg.equals("Nchster Iterationsschritt")) {
      	start.setEnabled(false);
      	stop.setEnabled(false);
        algorithm.next();
        start.setEnabled(true);
        if (start.getLabel() == "Nchster Iterationsschritt") stop.setEnabled(true);
        return true;
      }
      
    }
     
    return super.action(e,arg);
  }

}
